<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('category_id', 'title', 'image', 'text');

    public function getCategory()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function getClients()
    {
        return $this->belongsToMany('App\Models\Client');
    }

}